package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;

public class DoorDestinationPaletteObject extends ScreenPaletteObject {
	

	private static CustomImageDataII doorDestImage;
	private int heightPlusCaption = -1;
	private String caption;
	private Color captionColor;
	
	private DoorDestinationScreenObject createdObject;
	private DoorSourcePaletteObject source;
	
	public static synchronized CustomImageDataII getDoorDestImage(ImageObserver io) {
		
		if(doorDestImage == null)
			doorDestImage = new CustomImageDataII("/images/doorDest.GIF", Color.white, io);
		
		return doorDestImage;
		
	}
	
	
	private RoomEditorPanel sourceRoom;
	
	
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		
		DoorDestinationScreenObject returnValue = new DoorDestinationScreenObject(objX, objY, this);
		createdObject = returnValue;
		return returnValue;
	}

	@Override
	public void delete(ScreenObject so) {
		createdObject = null;
	}

	@Override
	public void draw(Graphics g) {
		if(clickRect == null)
			return;
		
		doorDestImage.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		FontRenderContext frc = g.getFontMetrics().getFontRenderContext();
		String dispStr = "from: " + this.getSourceRoom().getStaticBlockFactory().getRoomName();
		Rectangle2D strBounds = g.getFont().getStringBounds(dispStr, frc);
		g.setColor(Color.white);
		g.fillRect(clickRect.getMinX(), clickRect.getMaxY() + 2, 4 + (int) strBounds.getWidth(), 4 + (int) strBounds.getHeight());
		heightPlusCaption = clickRect.height() + 8 + (int) strBounds.getHeight();
		g.setColor(Color.black);
		g.drawString(dispStr, clickRect.getMinX() + 2,  clickRect.getMaxY() + 20);
		
		
		if(caption != null && captionColor != null) {
			g.setColor(captionColor);
			
			Font origFont = g.getFont();
			Font newFont = new Font(origFont.getName(), Font.BOLD, 18);
			g.setFont(newFont);
			g.drawString(caption, clickRect.getMinX() + 4, clickRect.getMaxY() - 10);
			g.setFont(origFont);
		}
		
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
	}
	
	
	public DoorDestinationPaletteObject(IntRect theClickRect, int theDistanceToBorder, int theBorderWidth, RoomEditorPanel theSourceRoom, RoomEditorPanel theDestinationRoom, DoorSourcePaletteObject theSource) {
		
		getDoorDestImage(theDestinationRoom);
		
		sourceRoom = theSourceRoom;
		source = theSource;
		
		clickRect = theClickRect;
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		editorPanel = theDestinationRoom;
		
	}
	
	public RoomEditorPanel getSourceRoom() {
		return sourceRoom;
	}
	
	public int getWidth() {
		return clickRect.width();
	}
	
	public int getHeight() {
		return clickRect.height();
	}
	
	public RoomEditorPanel getDestionationRoom() {
		return editorPanel;
	}
	
	public boolean shouldShowCaption() {
		return editorPanel.doorsShouldShowDestinationsAndSources();
	}
	
	public int getHeightOfCaptionIncludeSpacing() {
		if(heightPlusCaption == -1)
			return this.clickRect.height();
		else
			return heightPlusCaption;
	}
	
	public void setCaption(String newCaption) {
		caption = newCaption;
	}
	
	public void setCaptionColor(Color newColor) {
		captionColor = newColor;
	}

	public String getCaption() {
		return caption;
	}

	public Color getCaptionColor() {
		return captionColor;
	}
	
	public boolean screenObjectAlreadyExists() {
		return createdObject != null;
	}
	
	public DoorDestinationScreenObject getDestionationPoint() {
		return createdObject;
	}
	
	public void setDestinationPoint(DoorDestinationScreenObject destPoint) {
		createdObject = destPoint;
	}
}
